import numpy as np
from sklearn.decomposition import PCA
from sklearn.neighbors import KernelDensity
from scipy.stats import entropy
from scipy.stats import wasserstein_distance
from sklearn.preprocessing import StandardScaler



def wasserstein_distance_tasks(data, data_old):
    data = data.cpu().numpy()
    task_data = data_old.cpu().numpy()  # 转为 NumPy
    # 计算所有维度的 Wasserstein 距离，并取均值
    dim_distances = [wasserstein_distance(data[:, d], task_data[:, d]) for d in range(data.shape[1])]
    avg_distance = sum(dim_distances) / len(dim_distances)
    return avg_distance








